package gov.va.med.mhv.mrp.service.converter;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalsTaskActivitiesDTO;
import gov.va.med.mhv.mrp.data.model.MyGoalsTaskActivities;

@Component
public class MyGoalsTaskActivitiesDTOConverter implements Converter<MyGoalsTaskActivitiesDTO, MyGoalsTaskActivities> {
	private static Logger log = LogManager.getLogger(MyGoalsTaskActivitiesDTOConverter.class);

	@Override
	public MyGoalsTaskActivities convert(MyGoalsTaskActivitiesDTO dto) {
		MyGoalsTaskActivities e = new MyGoalsTaskActivities();
		
		log.debug("start");
		
		e.setActivityDate(dto.getActivityDate());
		e.setOplock(dto.getOplock());
		e.setTaskActivityId(dto.getTaskActivityId());
		e.setTaskRepetitionCycleType(dto.getTaskRepetitionCycleType());
		e.setUpdatedTime(dto.getUpdatedTime());
		
		log.debug("end");
		
		return e;
	}

}
